<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ImageLanguage extends Model 
{

    protected $table = 'lim_image_languages';
    public $timestamps = true;
    protected $fillable = array('lim_language_id', 'lim_image_id', 'name', 'alt', 'title');
    protected $visible = array('lim_language_id', 'lim_image_id', 'name', 'alt', 'title');

    public function language()
    {
        return $this->belongsTo('App\Models\Language', 'lim_language_id');
    }

    public function image()
    {
        return $this->belongsTo('App\Models\Image', 'lim_image_id');
    }

}